<?php

namespace Database\Factories;

use App\Models\Customer;
use Illuminate\Database\Eloquent\Factories\Factory;

class CustomerFactory extends Factory
{
	/**
	 * The name of the factory's corresponding model.
	 *
	 * @var string
	 */
	protected $model = Customer::class;

	/**
	 * Define the model's default state.
	 *
	 * @return array
	 */
	public function definition()
	{
		$address = $this->faker->address();

		return [
			'name' => $this->faker->name,
			'email' => $this->faker->unique()->safeEmail,
			'phone' => $this->faker->e164PhoneNumber(),
			'user_type' => 'customers',
			'address' => $address,
			'shipping_address' => $address,
		];
	}
}
